/* 
 * File:   mainmenu.h
 * Author: User
 *
 * Created on 20 November 2015, 3:00 PM
 */

#include "menu.h"
#include "Timezone/tz_coords.h"
#include "Timezone/tzmaths.h"

#ifndef MAINMENU_H
#define	MAINMENU_H

#ifdef	__cplusplus
extern "C" {
#endif

extern cycleitem tz_cycle[sizeof(timezones)/sizeof(*timezones)+2];
extern cycleitem dst_cycle[];
extern cycleitem month_cycle[];
extern cycleitem week_cycle[];
extern cycleitem day_cycle[];
extern cycleitem dsmod_cycle[];
extern cycleitem column_led_cycle[];
extern cycleitem date_format_cycle[];

extern menuitem tz_submenu[];
extern menuitem dst_submenu[];
extern menuitem alarm_submenu[];
extern menuitem autodim_submenu[];
extern menuitem piezo_submenu[];
extern menuitem options_submenu[];
#ifdef SHOW_UTC_FEATURE
extern menuitem ir_codes_submenu[30];
#else
extern menuitem ir_codes_submenu[29];
#endif
extern menuitem ir_submenu[];
extern menuitem mainmenu[];

__attribute__((mips16)) void mainmenu_set_mode(int timezone, signed long* tzinfo, daylight_savings_info* dstinfo);
__attribute__((mips16)) void mainmenu_callback(menu_callback_type type, menuitem* item);
__attribute__((mips16)) void change_rtcc_from_UTC_to_local();
__attribute__((mips16)) void change_rtcc_from_local_to_UTC();

#define GLOBAL_ALARM_FLAG (alarm_submenu[0].name[5] == 'N')
#define _24HR_MODE (options_submenu[0].name[0] == '2')
#define PM_DP_MODE (options_submenu[1].name[5] == 'H' ? 2 : (options_submenu[1].name[5] == '@' ? 8 : (options_submenu[1].name[5] == 'S' ? 32 : 0)))
#define LEADING_ZERO_BLANKING (options_submenu[2].name[5] != 'F')
#define COLONS_ON (options_submenu[3].name[0] == 'C' && options_submenu[3].name[5] != 'F')
#define COLONS_FLASH (options_submenu[3].name[0] == 'C' && options_submenu[3].name[3] == 'F')
#define DPS_ON (options_submenu[3].name[0] == 'D' && options_submenu[3].name[5] != 'F')
#define DPS_FLASH (options_submenu[3].name[0] == 'D' && options_submenu[3].name[3] == 'F')
#define DATE_FMT_DDMMYY (options_submenu[4].name[0] == 'D')
#define DATE_FMT_MMDDYY (options_submenu[4].name[2] == 'D')
#define DATE_FMT_YYMMDD (options_submenu[4].name[0] == 'Y')
#define OPTS_XTAL_TRIM (options_submenu[7].data.b.c.num.val)
#define ALARM_ON(wday) (alarm_submenu[(wday) == 0 ? 7 : (wday)].name[5] == 'N')
#define ALARM_TIME(wday) (alarm_submenu[(wday) == 0 ? 7 : (wday)].data.b.c.val)
#define PIEZO_DURATION_SEC piezo_submenu[0].data.b.c.num.val
#define PIEZO_PULSE_FREQ_HZ piezo_submenu[1].data.b.c.num.val
#define PIEZO_DUTY_PCT piezo_submenu[2].data.b.c.num.val
#define PIEZO_CADENCE piezo_submenu[3].data.b.c.val
#define DISPLAY_BRIGHTNESS autodim_submenu[0].data.b.c.num.val
#define AUTODIM_ULIMIT autodim_submenu[1].data.b.c.num.val
#define AUTODIM_LLIMIT autodim_submenu[2].data.b.c.num.val
#define AUTODIM_MINBR  autodim_submenu[3].data.b.c.num.val
#define GPS_LOCK_REQUIRED (options_submenu[8].data.b.c.val == 0)

#define IRCODE_0      ir_codes_submenu[ 0].data.b.c.val
#define IRCODE_1      ir_codes_submenu[ 1].data.b.c.val
#define IRCODE_2      ir_codes_submenu[ 2].data.b.c.val
#define IRCODE_3      ir_codes_submenu[ 3].data.b.c.val
#define IRCODE_4      ir_codes_submenu[ 4].data.b.c.val
#define IRCODE_5      ir_codes_submenu[ 5].data.b.c.val
#define IRCODE_6      ir_codes_submenu[ 6].data.b.c.val
#define IRCODE_7      ir_codes_submenu[ 7].data.b.c.val
#define IRCODE_8      ir_codes_submenu[ 8].data.b.c.val
#define IRCODE_9      ir_codes_submenu[ 9].data.b.c.val
#define IRCODE_ESCAPE ir_codes_submenu[10].data.b.c.val
#define IRCODE_DATE   ir_codes_submenu[11].data.b.c.val
#define IRCODE_CNTUP  ir_codes_submenu[12].data.b.c.val
#define IRCODE_CNTDN  ir_codes_submenu[13].data.b.c.val
#define IRCODE_BRIUP  ir_codes_submenu[14].data.b.c.val
#define IRCODE_BRIDN  ir_codes_submenu[15].data.b.c.val
#define IRCODE_UP     ir_codes_submenu[16].data.b.c.val
#define IRCODE_DOWN   ir_codes_submenu[17].data.b.c.val
#define IRCODE_LEFT   ir_codes_submenu[18].data.b.c.val
#define IRCODE_RIGHT  ir_codes_submenu[19].data.b.c.val
#define IRCODE_SELECT ir_codes_submenu[20].data.b.c.val
#define IRCODE_TI_SUB ir_codes_submenu[21].data.b.c.val
#define IRCODE_TI_RES ir_codes_submenu[22].data.b.c.val
#define IRCODE_TI_ADD ir_codes_submenu[23].data.b.c.val
#define IRCODE_TI_LAP ir_codes_submenu[24].data.b.c.val
#define IRCODE_TI_PAU ir_codes_submenu[25].data.b.c.val
#define IRCODE_ALA_ON ir_codes_submenu[26].data.b.c.val
#define IRCODE_DISPON ir_codes_submenu[27].data.b.c.val
#ifdef SHOW_UTC_FEATURE
#define IRCODE_SHOUTC ir_codes_submenu[28].data.b.c.val
#endif

#define MAX_MENU_STATE_SIZE 53

#ifdef	__cplusplus
}
#endif

#endif	/* MAINMENU_H */
